/**************************************************************************
PLUSIEURS SPRITES ANIMES

          ce programme illustre l'animation de plusieurs personnage (animaux)
          qui traversent l'cran

          Pour avoir plusieurs squences animes
          il faut plusieurs tableaux de bitmaps
          correspondant aux squences d'images

          Ici, chaque structure de type t_sequence regroupe
          les images d'une squence, et on utilise un tableau
          global tabSequences de ces structures

          Pour viter d'avoir  grer des quantits
          importantes de petits fichiers images, chaque
          squence image est regroupe dans un mme .bmp
          La procdure void chargerSequence(t_sequence * seq);
          permet de dcouper cette image de dpart en petite bitmaps
          (une pour chaque tape de l'animation)
**************************************************************************/

#include <allegro.h>
#include <time.h>


/***************************************************/
/*                   CONSTANTES                    */
/*            devront aller dans un .h             */
/***************************************************/

// sur cet exemple Nombre d'acteurs fixe :
//    le tableau d'acteurs sera dclar et utilis en "automatique"
//    t_acteur tab[NACTEUR];
// Pour modifier cette valeur il faut adapter remplirTabActeurs
#define NACTEUR 6

// nombre total de squences d'animation du jeu
// ( le nombre d'acteurs peut tre suprieur si plusieurs acteurs utilisent les mme graphismes )
// Pour modifier cette valeur il faut modifier le tableau initialis tabSequences
#define NSEQUENCE 6


/*****************************/
/*       STRUCTURES          */
/*  devront aller dans un .h */
/*****************************/

// donnes pour chaque squence d'animation charge initialement
//  (  ne faire qu'une seule fois au dbut du jeu )
typedef struct sequence
{
    char *nomSource; // nom du fichier image contenant la squence
    int nimg;        // nombre d'images dans la squence
    int tx,ty;       // largeur et hauteur des images de la squence
    int ncol;        // nbr images cotes  cotes horizontalement dans le fichier image
    BITMAP **img;    // tableau de pointeurs pour indiquer les images
} t_sequence;

// donnes personnelles de chaque acteur qui se dplace
// sur cet exemple on ne gre que des dplacements horizontaux (pas de dy...)
typedef struct acteur
{
    // gomtrie et dplacements

    int x,y;         // position du coin sup. gauche
    int dx;          // deplacement
    int tmpdx;       // ralentir dplacements en x (1 pour ne pas ralentir)
    int cptdx;       // compteur pour ralentir dplacement
    int tx,ty;       // largeur hauteur

    // squence d'images de l'animation

    int imgcourante; // indice de l'image courante
    int tmpimg;      // ralentir squence (image suivante 1 fois sur tmpimg)
    int cptimg;      // compteur pour ralentir squence

    // type = numro de la sequence  utiliser dans tabSequences
    // ( ici : 0 Dragon  1 Poisson  2 Crabe  3 Abeille  4 Moustique  5 Serpent )

    int type;

} t_acteur;


/*****************************/
/*       PROTOTYPES          */
/*  devront aller dans un .h */
/*****************************/

// Allouer et initialiser un acteur
t_acteur * creerActeur(int type, int x, int y, int dx, int tmpdx, int tmpimg);

// Pour remplir un tableau avec des acteurs crs
// Sur cet exemple on cre 6 acteurs, chacun associ  une squence
void remplirTabActeurs(t_acteur * tab[NACTEUR]);


// Actualiser un acteur (bouger ...)
void actualiserActeur(t_acteur *acteur);

// Grer l'volution de l'ensemble des acteurs
void actualiserTabActeurs(t_acteur * tab[NACTEUR]);


// Dessiner un acteur sur une bitmap bmp
void dessinerActeur(BITMAP *bmp, t_acteur *acteur);

// Dessiner l'ensemble des acteurs sur une bitmap bmp
void dessinerTabActeurs(BITMAP *bmp,t_acteur * tab[NACTEUR]);


// Charger les images d'une squence d'animation
// Dcoupe une image source en plusieurs vignettes
// (doivent tre ranges de gauche  droite et de haut en bas)
void chargerSequence(t_sequence * seq);

// Charger toutes les squences du tableau global tabSequence
void chargerTabSequences();



/***************************************************/
/*              VARIABLES GLOBALES                 */
/*  les dclarations devront aller dans un .h      */
/*  les dfinitions devront aller dans un .c       */
/***************************************************/


// tableau global de toutes les squences animes du jeu
// on s'autorise  utiliser un tableau global car ces donnes
// n'existent qu'en un seul exemplaire  l'chelle du programme
t_sequence tabSequences[NSEQUENCE] =
{
        //          nomSource           , nimg,  tx,  ty, ncol
        { "images/dragon/dragon.bmp"    ,    6, 128,  64,    3 },
        { "images/dragon/poisson.bmp"   ,    3,  64,  32,    3 },
        { "images/dragon/crabe.bmp"     ,    4,  64,  32,    4 },
        { "images/dragon/abeille.bmp"   ,    6,  50,  40,    6 },
        { "images/dragon/moustique.bmp" ,    6,  50,  40,    6 },
        { "images/dragon/serpent.bmp"   ,    7, 100,  50,    4 }
};



/******************************************/
/* PROGRAMME PRINCIPAL                    */
/* initialisation puis boucle d'animation */
/******************************************/

int main()
{
    // Le tableau regroupant tous les acteurs
    // c'est un tableau de pointeurs sur structures t_acteurs
    t_acteur * mesActeurs[NACTEUR];

    // BITMAP servant de buffer d'affichage (double buffer)
    BITMAP *page;

    // Image de fond
    BITMAP *decor;

    // On va utiliser du hasard
    srand(time(NULL));

    // Lancer allegro et le mode graphique
    allegro_init();
    install_keyboard();

    set_color_depth(desktop_color_depth());
    if (set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,480,0,0)!=0)
    {
        allegro_message("prb gfx mode");
        allegro_exit();
        exit(EXIT_FAILURE);
    }

    // Cration du buffer d'affichage  la taille de l'cran
    page=create_bitmap(SCREEN_W,SCREEN_H);
    clear_bitmap(page);

    // charger image de fond
    decor=load_bitmap("images/dragon/decor.bmp",NULL);
    if (!decor)
    {
        allegro_message("pas pu trouver images/dragon/decor.bmp");
        exit(EXIT_FAILURE);
    }


    // Chargement des images des squences animes
    chargerTabSequences();

    // Initialisation alatoire des paramtres des acteurs :
    // remplir le tableau avec des acteurs allous et initialiss
    remplirTabActeurs(mesActeurs);

    // Boucle d'animation (pas d'interaction)
    while (!key[KEY_ESC])
    {

        // 1)  EFFACER BUFFER, en appliquant dcor  (pas de clear_bitmap)
        blit(decor,page,0,0,0,0,SCREEN_W,SCREEN_H);

        // 2) DETERMINER NOUVELLEs POSITIONs
        actualiserTabActeurs(mesActeurs);

        // 3) AFFICHAGE NOUVELLEs POSITIONs SUR LE BUFFER
        dessinerTabActeurs(page,mesActeurs);

        // 4) AFFICHAGE DU BUFFER MIS A JOUR A L'ECRAN
        blit(page,screen,0,0,0,0,SCREEN_W,SCREEN_H);

        // 5) ON FAIT UNE PETITE PAUSE  chaque fois sinon a va trop vite...
        rest(20);
    }

    return 0;
}
END_OF_MAIN();



/************************************************/
/*     DEFINITIONS DES SOUS-PROGRAMMES          */
/*  devront aller dans un autre .c : acteurs.c  */
/************************************************/


// Allouer et initialiser un acteur
t_acteur * creerActeur(int type, int x, int y, int dx, int tmpdx, int tmpimg)
{
    // pointeur sur l'acteur qui sera cr (et retourn)
    t_acteur *acteur;

    // Cration (allocation)
    acteur = (t_acteur *)malloc(1*sizeof(t_acteur));

    // Initialisation gomtrie et dplacement
    acteur->x=x;           acteur->y=y;
    acteur->dx=dx;
    acteur->tmpdx=tmpdx;
    acteur->cptdx=0;
    acteur->tx=tabSequences[type].tx;
    acteur->ty=tabSequences[type].ty;

    // Initialisation squence d'images de l'animation
    acteur->imgcourante=0;
    acteur->tmpimg=tmpimg;
    acteur->cptimg=0;

    // numro de squence
    acteur->type=type;

    // on retourne cet acteur fraichement cr
    return acteur;
}

// Pour remplir un tableau avec des acteurs crs
// Sur cet exemple on cre 6 acteurs, chacun associ  une squence
void remplirTabActeurs(t_acteur * tab[NACTEUR])
{
    // Appeler NACTEUR fois creerActeur avec les paramtres souhaits :
    //                (type,   x,   y,  dx, tmpdx, tmpimg )
    tab[0]=creerActeur(   0, 500,   0,  -5,     1,      5 );
    tab[1]=creerActeur(   1, 300, 400,   3,     1,      8 );
    tab[2]=creerActeur(   2, 300, 212,   2,     6,     20 );
    tab[3]=creerActeur(   3, 100, 122,  -3,     1,      8 );
    tab[4]=creerActeur(   4, 500,  70,   4,     1,      2 );
    tab[5]=creerActeur(   5, 350, 200,  -2,     1,      4 );
}


// Actualiser un acteur (bouger ...)
void actualiserActeur(t_acteur *acteur)
{

    // gestion des bords " la pac man"
    // sur cet exemple seulement sur l'axe x (car pas de dy)
    if (acteur->x+acteur->tx < 0) acteur->x=SCREEN_W;
    if (acteur->x > SCREEN_W) acteur->x=-acteur->tx;

    // calculer nouvelle position
    // nouvelle position = position actuelle + deplacement seulement une fois sur tmpdx
    // sur cet exemple seulement sur l'axe x (car pas de dy)
    acteur->cptdx++;
    if (acteur->cptdx >= acteur->tmpdx){
        acteur->cptdx=0;
        acteur->x = acteur->x + acteur->dx;
    }

    // gestion enchainement des images
    // incrmenter imgcourante une fois sur tmpimg
    acteur->cptimg++;
    if (acteur->cptimg >= acteur->tmpimg){
        acteur->cptimg=0;
        acteur->imgcourante++;
        // quand l'indice de l'image courante arrive  nimg de la squence
        // on recommence la squence  partir de 0
        if ( acteur->imgcourante >= tabSequences[ acteur->type ].nimg )
            acteur->imgcourante=0;
    }
}

// Grer l'volution de l'ensemble des acteurs
void actualiserTabActeurs(t_acteur * tab[NACTEUR])
{
    int i;

    for (i=0;i<NACTEUR;i++)
        actualiserActeur(tab[i]);
}


// Dessiner un acteur sur une bitmap bmp
void dessinerActeur(BITMAP *bmp, t_acteur *acteur)
{
    // Pointeur sur la squence concerne (prise en compte du type de l'acteur)
    t_sequence *seq;
    seq=&tabSequences[ acteur->type ];

    //  Prise en compte du numro d'image courante de l'acteur dans cette squence
    draw_sprite(bmp, seq->img[ acteur->imgcourante ], acteur->x, acteur->y);
}

// Dessiner l'ensemble des acteurs sur une bitmap bmp
void dessinerTabActeurs(BITMAP *bmp,t_acteur * tab[NACTEUR])
{
    int i;

    for (i=0;i<NACTEUR;i++)
        dessinerActeur(bmp,tab[i]);
}


// Charger les images d'une squence d'animation
// Dcoupe une image source en plusieurs vignettes
// (doivent tre ranges de gauche  droite et de haut en bas)
void chargerSequence(t_sequence * seq)
{
    BITMAP *source;  // la bitmap qui charge l'image de squence (temporairement)
    int i;           // indice de l'image dans la squence
    int ix,iy;       // indices (horizontal et vertical) dans le "tableau" des images
    int sx,sy;       // coordonnes correspondantes (en pixels)


    // Charger l'image de squence
    source=load_bitmap(seq->nomSource,NULL);
    if (!source)
    {
        allegro_message("pas pu trouver %s", seq->nomSource);
        exit(EXIT_FAILURE);
    }

    // Allouer le tableau de pointeur sur les images de l'animation
    seq->img=(BITMAP **)malloc(seq->nimg*sizeof(BITMAP *));

    // Allouer les images de l'animation et les rcuprer sur l'image source
    ix=0;
    iy=0;
    for (i=0;i<seq->nimg;i++)
    {
        // allouer image
        seq->img[i]=create_bitmap(seq->tx,seq->ty);

        // rcuprer image
        sx=ix*seq->tx;
        sy=iy*seq->ty;
        blit(source,seq->img[i],sx,sy,0,0,seq->tx,seq->ty);

        // prparer indices pour l'image suivante
        ix++;          // colonne suivante
        if (ix >= seq->ncol)  // si je suis  droite de la dernire colonne alors...
        {
            ix=0;      // repartir sur la colonne 0
            iy++;      //  la ligne en dessous
        }
    }

    // On a fini de rcuprer sparment chaque tape (image) de l'animation
    // on n'a donc plus besoin de l'image source qui les regroupe
    destroy_bitmap(source);
}

// Charger toutes les squences du tableau global tabSequence
void chargerTabSequences()
{
    int i;

    for (i=0;i<NSEQUENCE;i++)
        chargerSequence(&tabSequences[i]);
}
